const express = require("express");
const router = express.Router();
const bcrypt = require("bcryptjs");
const jwt = require("jsonwebtoken");
const User = require("../models/User");

// register

router.post("/register", async (req, res) => {
    try {
        if (req.body.role === 'admin') {
            const existingAdmin = await User.findOne({ role: 'admin' });
            if (existingAdmin) {
                return res.status(400).json({ message: "Admin account already exists" });
            }
        }

        const hash = await bcrypt.hash(req.body.password, 10);
        const user = new User({
            ...req.body,
            password: hash
        });

        await user.save();
        res.status(201).json({ message: "User Registered" });
    } catch (err) {
        res.status(500).json({ message: "Server Error", error: err.message });
    }
});

// login
router.post("/login", async (req, res) => {
    try {
        const { email, password } = req.body;

        const user = await User.findOne({ email });
        const isMatch = bcrypt.compare(password, user.password);

        if (!user) {
            return res.status(404).json({ message: 'User not found' });
        }


        if (!isMatch) {
            return res.status(401).json({ message: 'Invalid Password' });
        }

        const token = jwt.sign({ id: user._id, role: user.role }, process.env.JWT_SECRET, { expiresIn: '1d' });

        res.json({ token });
    }
    catch (err) {
        res.status(500).json({ message: "Server Error", error: err.message });
    }
})

module.exports = router;